# The Impact of COVID-19 Pandemic on Education System in Developing Countries: A Review

Seble Tadesse1, Worku Muluye2

1 Department of Agricultural Economics, Wolkite University, Wolkite, Ethiopia 2 Department of Information Systems, Wolkite University, Wolkite, Ethiopia Email: sebletadese44@gmail.com

How to cite this paper: Tadesse, S., & Muluye, W. (2020). The Impact of COVID-19 Pandemic on Education System in Developing Countries: A Review. Open Journal of Social Sciences,8,159-170. https://doi.org/10.4236/jss.2020.810011

Received: September 17, 2020   
Accepted: October 23, 2020   
Published: October 26, 2020

Copyright $^ ©$ 2020 by author(s) and Scientific Research Publishing Inc. This work is licensed under the Creative Commons Attribution International License (CC BY 4.0). http://creativecommons.org/licenses/by/4.0/

# Abstract

Coronavirus affects the education system in the world. Schools, colleges, and universities are closed to control the spread of the coronavirus. School closure brings difficulties for students, teachers, and parents. So, distance learning is a solution to continue the education system. However, the lack of network infrastructures, computers, and internet access is challenging distance learning in developing countries. This paper aims to review the impact of the COVID-19 pandemic on the education system in developing countries. Hence, countries design a strategy to use educational technology, zero-fee internet educational resources, free online learning resources, and broadcasts teaching. During closures, educational institutions design curriculum, prepare teaching-learning strategies for post-coronavirus. The educational institutions design strategies to recover lost learning, and return students to school when schools reopen. Coronavirus has been impacting the face-to-face education system of developing countries. Therefore, developing countries should enhance broadcast teaching, online teaching, and virtual class infrastructures.

# Keywords

Coronavirus, Developing Country, Distance Learning, Education System, Impacts of COVID-19

# 1. Introduction

The coronavirus (COVID-19) is a pandemic disease that affects the education system of different income level countries (Wajdi et al., 2020). The United Nations Education, Scientific, and Cultural Organization (UNESCO) has been recognized that the coronavirus pandemic outbreak has impacted the education system in the world (UNESCO, 2020b). A lot of pandemics have occurred in human history, and affected human life, education system, and economic development in the world (Editors, 2020). The World Health Organization (WHO) (WHO, 2020a) on March 11, 2020, has officially announced that coronavirus (COVID-19) is a pandemic after it covers 114 countries in 3 months and infects more than 118,000 people in the world. The first COVID-19 case has reported by Wuhan Municipal Health Commission on December 31, 2019, in the Hubei Province, China (WHO, 2020b). The coronavirus pandemic is quickly spreading and affecting 213 territories and countries throughout the world. In the world about 30,086,319 of total cases, 21,833,645 of total recovered and 945,962 of total deaths were recorded until September 17, 2020 (Worldometer, 2020). According to (Medical News Today, 2020), the researchers believe that coronavirus is spreading exponentially and many countries are locked in their education system, and enforcing their people strict quarantine to control the spread of this highly contagious disease. The governments focus on fulfilling equipment, organizing medical institutions, and laboratory centers, identification of the virus, training health workers, and creating awareness for their people (Haleem et al., 2020). Education has been the pillar of development of every country, so education is principal to the development and growth of all countries. The education system has been affected by several challenges ranging from changes in the education curriculum to closing down the education system due to widespread pandemic diseases (Owusu-Fordjour et al., 2015).

As UNESCO (UNESCO, 2020b) reports that $8 7 \%$ of the world’s student population is affected by COVID-19 school closures. UNESCO is launching distance learning practices and reaching students who are most at risk. According to the UNESCO, over 1.5 billion students in 195 countries are affected by COVID-19 pandemic school closures. In (Niranjan, 2020) studied that COVID-19 impacted not only the overall economy and our day to day life, but also emotional, mental, and physical health, also, losses in national and international business, poor cash flow in the market, locked national and international traveling; moreover, disruption of the celebration of cultural, and festive events, stress among the population, the closures of hotels, restaurants, religious, and entertainment places (Evans, 2020). In many developing countries the economic shock has come first, as governments have locked down their economies to reduce the speed of infection. As a result, developing countries are suffering their greatest economic decline and closures of their education and transportation system (Haleem et al., 2020). Distance learning solutions are containing platforms, educational applications, and resources that aimed to help parents, students, and teachers. Digital learning management systems, massive open online course platforms, and self-directed learning content (UNESCO, 2020a). However, due to lack of internet connectivity, information technology, educational materials, and digital technology skill distance learning is difficult for teachers, students, and families in developing countries (Mustafa, 2020). Some developing countries deliver classes through radio, television, and online platforms. However, the poorest families and students have not radio, television, and other devices to access the resources and to learn at their home. So, some developing countries provide resources such as textbooks, radios, equipment, and study guides to the poorest students (Mustafa, 2020).

In this study, the impact of coronavirus on the education system, impacts of COVID-19 on children, students, teachers, and parents, the recommended solutions about the continuity of education system during COVID-19, online learning challenges, and opportunities, and education system after coronavirus related articles have been reviewed and discussed.

# 2. Impact of COVID-19 on Education System

In the world, most countries have temporarily closed child-cares, nursery, primary and secondary schools, colleges, and universities to control the spread of the COVID-19 pandemic (TUAC Secretariat Briefing, 2020). COVID-19 impacts not only students but also it affects teachers and parents across the world. UNESCO reported that over 1.5 billion students in 195 countries are out of school in the world due to the school closures (UNESCO, 2020b). As (Pujari, 2020) COVID-19 affects all over the education system, examinations, and evaluation, starting of new semester or term and it may extend the school year.

# 2.1. Teachers, Students, and Parents

The pandemic of COVID-19 pandemic is affecting schools, students, teachers, and parents. The COVID-19 crisis increases social inequality in schools. Students from more advantaged parents attend schools with better digital infrastructure and teachers might have higher levels of digital technology skills. Some schools can be well equipped in digital technology and educational resources. Disadvantaged students are attending schools with lower ICT infrastructure and educational resources (Di Pietro et al., 2020). Following COVID-19 more advantaged students are attending schools to adopt online learning. Schools in disadvantaged, rural areas lack the appropriate digital infrastructure required to deliver teaching at the remote. Also, there is a significant difference between private and public schools in technology and educational resources. In most countries, private schools are more effective than public schools. Students’ have not equal access to digital technology and educational materials. In the (Woday et al., 2020) survey, the study finds during schools closure the level of anxiety, depression disorders, and stress are high among students.

Distance learning is a solution to continue the education system, but it is difficult in developing countries because many parents have not themselves been to school and there is a lack of the necessary Information and Communication Technology (ICT) infrastructures, computers, radio, and television to provide distance learning. Access to computers and access to the internet is basic to successful distance teaching. This is not guaranteed for all students in developing countries (Zhang, 2020). Also, staff and teachers should familiar with online teaching platforms. Teachers struggle with difficulties in the area of technology and lack of infrastructure availability. Some private schools may not pay their staffs’ salary and some schools may pay half salary. COVID-19 affects poor families since many students don’t have access to the equipment at home. The physical school closure and the implementation of distance education lead the student to spent less time learning, stress, and lack of learning motivation (Di Pietro et al., 2020).

# 2.2. Unequal Access to Educational Resources and Technology

The school’s closure due to COVID-19 may not affect students equally. Students from less advantaged backgrounds highly suffered during COVID-19 than advantaged students (Di Pietro et al., 2020). To control the coronavirus spread, most countries have been working to encourage parents and schools to help students continue to learn at home through distance learning (UNESCO, 2020a). The governments advised students to learn from radio and television lessons that can be accessed at home. The radio and television lessons may work for some children and students in urban areas, but most parents in rural areas have not accessed to radios and television lessons. For example, in Ethiopia, more than $8 0 \%$ of the population lives in rural areas with limited or no access to electric power, so that it is challenging for students in rural areas to learn from radio and television lessons (Tiruneh, 2020). The schools in urban areas are teaching their students from a distance by uploading assignments, books, and reading materials through Google Classroom, e-mail, social media, and other applications. In some urban areas, even if distance learning is provided due to a lack of monitoring strategies some students may not use it properly. Private schools sending learning materials directly to parents through social media platforms. There is a difference between rural and urban schools and the public and private schools to keep their students learning from home. Also, public school teachers and students have limited or no access to the internet (Tzifopoulos, 2020).

The school closure brings difficulties for students, families, and teachers of developing countries. Students from poor families with lower educational levels and children with poor learning motivation suffer most during coronavirus. The children may have higher dependence than younger students on parents and they need guidance in their learning process, internet access, and usage of digital devices and applications (Tzifopoulos, 2020). Furthermore, poor and digitally-illiterate families’ children are further suffering (Tiruneh, 2020). There were already inequalities before coronavirus in access to quality education between students in urban and rural areas, and students from families with higher and lower socioeconomic status. School closures could further increase the inequalities between students (Owusu-Fordjour et al., 2015). Students in rural areas and from disadvantaged families lack access to technology, internet access, and educational resources (Di Pietro et al., 2020).

# 2.3. Assessment and Evaluation

Distance learning is a good opportunity for teachers, students, and families. In (Zhu & Liu, 2020) developed actions such as introduced online learning platforms, use Blackboard, Zoom, TronClass, Classin, and Wechat group platforms, and conducted online training, and collected information about all courses. Online teaching and learning are not a new mode of delivery for developed countries and some developing countries. However, shifting from face-to-face class to online learning is challenging for teachers, students, families, and the countries government due to lack of finance, skill, ICT infrastructure, internet access, and educational resources (Basilaia & Kvavadze, 2020). Furthermore, computers and other IT equipment, at home are difficult for most parents, children, and students in developing countries (Sahu, 2020). Additionally, some courses are difficult or impossible to teach and learn through online learning methods such as sport, nursing, laboratories, music, and art courses.

The shift from face-to-face class to online class has a serious impact on assessments and evaluation. Depending on the course nature and the assessment type applying assessments and evaluation online is a challenging task. So that teachers have enforced to change their assessment types to fit the online mode. Also, it is difficult to monitor the student how they are taking courses online and difficult to ensure that students are not cheating during online exams (Basilaia & Kvavadze, 2020). Additionally, laboratory tests, practical tests, and performance tests are impossible to conduct online. Moreover, students who do not have internet access will suffer to take assessments and evaluations (Sahu, 2020). In (Osman, 2020) the assessment and evaluation of students’ performance in online learning is difficult for both instructors and students particularly teaching practicum, technical competencies, and the assessment of practical skills is difficult. According to (UNESCO, 2020b) report, even for students, teachers, and parents in countries with reliable ICT infrastructure and internet access, the rapid transition to online learning has been challenging. Students, parents, and teachers also require training to deliver online learning effectively, but such support is particularly limited in developing countries. Education inequalities are a threat to education system continuity at a time of unexpected educational system closures (UNESCO, 2020b). Because, there are a limited number of computers, internet access, mobile network access, and lack of ICT trained teachers in developing countries (O’Hagan, 2020). Therefore, even if online teaching and learning are a good opportunity to continue education during the pandemic it is challenging for developing countries (Sun et al., 2020).

# 2.4. Mental and Physical Health

The closures schools and higher education negatively affect the mental and physical health of children, students, parents, and teachers in the world, especially in developing countries (UNESCO, 2020b). Since during school closures, both boy and girl students in most rural areas may be forced to fully support their families in cattle herding and farming. Girl students from low-income families and rural areas can be at a higher risk of sexual abuse, and forced labor, and early marriage. The infected cases rapid increase has created a sense of anxiety and uncertainty about what will happen (Tiruneh, 2020). The lockdown due to coronavirus may people are feeling stress, fear, and anxiety, such as a fright of dying, a fear of their relatives dying (Sahu, 2020). This stress may affect the students, mental, and physical health of students. The pandemic may have a serious influence on the careers or may have not to graduate of this years’ higher education undergraduate students (Niranjan, 2020). All students may not have good interaction with online learning applications and platforms (Haleem et al., 2020), because some of the students are active and some may take a longer time to familiarize themselves with the system.

# 3. Continuity Education System during COVID-19

UNICEF (UNICEF, 2020) stated that in the case of school, college, and university closures, support continued access to quality education. This can include the use of distance learning strategies, assigning reading and exercises for home study, radio or television teaching of academic content, assigning teachers to conduct remote follow-up with students, and develop advanced education strategies. The pandemic has made all the education system across the world to adopt distance learning since the pandemic pushes face-to-face learning to online learning. So, in most developed countries, courses, and exams are conducted online by using different applications, and social networks (Sun et al., 2020). Used the situation as an opportunity to install network infrastructure and scale internet access across urban and rural areas (Viner et al., 2020). Students are started to learn from home and stay at home as much as possible, to maintain physical distancing, and to save themselves. In some countries, before COVID-19 there was an online learning system available but traditional face-to-face learning had the power (Tiruneh, 2020). But now online learning is going to be the first option. In many countries, teaching and learning progress is provided by using a distance learning method (Varalakshmi & Arunachalam, 2020). Digital learning management systems such as Google Classroom, and Moodle. Massive Open Online Course Platforms such as Alison, Coursera, EdX, and Udemy. Self-directed learning content such as Khan Academy, and OneCourse (UNESCO, 2020a).

The COVID-19 pandemic has not clear investigation when the virus will be controlled, but there is an indication it will at for two years and the virus will occur again and challenge the world. So, the countries should plan different strategies to continuity the education system through distance learning. Regarding this, the country designs a strategy to scale educational technology during pandemics, establish zero-rating educational resources on the internet, universal service funds and connecting schools to the internet, prepare online teaching and learning resources, utilizing free online learning resources, practice mobile learning, practice radio and television teaching and grow up ICT infrastructures (Tiruneh, 2020). Then identify each distance learning challenges and opportunities for children, students, teachers, and families. This helps to determine and control the bottleneck of online teaching and learning challenges.

The countries should practice the use of educational technologies at scale and install ICT infrastructures (Chick et al., 2020). Also, countries enable the students to access educational websites and applications without charge because the resources are zero-rated, in another word when the student access educational websites and applications don’t take data charges. Using universal service funds to scale internet access for students, teachers, and societies. But the pandemic is affecting the availability of funding for education (Niranjan, 2020). So, governments should design education financing policies and strategies to minimize the impact (Al-Samarrai et al., 2020). Access to online learning content from free open educational resources provided by non-profit publishers, and private companies (Wajdi et al., 2020). Increase the accessibility of educational resources on mobile phones. The parent should keep track of their children and avoid bad practices in mobile learning. Use the radio and television teaching approach, particularly where students can’t access other technologies at home. Install ICT infrastructure, and educational technologies to reach students in rural and the most challenging areas (Tiruneh, 2020). Use virtual classes to promote the progress and educational achievement of students. This helps to know about what works, and what doesn’t when it comes to the virtual class. The virtual class provides real-time interaction between nursing teachers and students $( \mathrm { N g \ \& \ O r } ,$ 2020).

# Education in Developed and Developing Countries during COVID-19

The COVID-19 pandemic has challenged the education community. The authors in (Crawford et al., 2020) discussed and analyzed the intra-period higher education’s responses of 20 countries in the world. They decided that to social distancing strategies on higher educations, needs a rapid curriculum redevelopment for fully online learning. In (Pujari, 2020) stated that due to the closure of school students, teachers, and parents fare facing various difficulties in India. So, online teaching is a better solution, feasible, and appropriate but it challenges poor parents and students. According to UNESCO reports the COVID-19 pandemic has interrupted the face-to-face class for at least 9 out of 10 students worldwide. Globally, 195 countries have closed all their schools, affecting over 1.5 billion students from pre-primary to higher education. In the worldwide $5 0 \%$ (826 million), $4 3 \%$ (706 million) of students do not have a computer and internet access at their home respectively. Also, about 56 million students cannot use mobile phones, because they are not covered by mobile networks. Sub-Saharan Africa Countries, about $8 9 \%$ (216 million), $8 2 \%$ (199 million), and $1 1 \%$ (26 million) of students do not have a computer, home internet access, and not covered by mobile networks respectively. Moreover, about 56 million students live in Sub-Saharan Africa not served by mobile networks. Furthermore, pandemic highlights the need for more ICT trained teachers. In developing countries, there is only 1 trained teacher for 56 students in primary education; and it is 1 trained teacher for 60 students (UNESCO, 2020b), (O’Hagan, 2020). This challenges to continue the education system during the COVID-19 pandemic in developing countries.

The governments of different income level countries are using different distance learning methods to continue education during school closures (Vegas, 2020). About $9 0 \%$ of high-income countries are delivered online learning and $2 0 \%$ are using a combination of broadcast and online learning. The upper-middle-income countries, over $7 0 \%$ provides a combination of broadcast and online learning. Also, about $6 6 \%$ of the lower-middle-income countries provide broadcast and/or online learning. Low-income countries, less than $2 5 \%$ are delivering education using television and radio education to their students. For instance, Europe, Central Asia, East Asia, the Pacific, the Caribbean, and Latin America most countries are providing distance learning via online learning fully and the combination of broadcast and online learning to teach rural area students. In the North and Middle East Africa, about $2 8 \%$ of countries are providing only radio and television teaching, less than $4 0 \%$ provide only online learning, and $2 2 \%$ are providing a combination of broadcast and online learning. In South Asia, $4 0 \%$ of countries are providing broadcast education, and $5 0 \%$ are providing a combination of broadcast and online learning. In Sub-Saharan Africa, $1 1 \%$ of countries are providing only online learning, and $2 3 \%$ of countries are providing a combination of broadcast and online learning (Thomas, 2020). However, low-income and middle-income countries offering broadcast and online learning are not reach most students (Winthrop, 2020).

The country’s governments should provide training to teachers on technology-based education during the COVID-19 crisis. In South Asia, $5 0 \%$ of countries provide training and guidance to teachers. In Europe, Central Asia, North and Middle East Africa, over $5 0 \%$ , the Caribbean and Latin America $4 8 \%$ , and $4 0 \%$ in the Pacific and East Asia provide training to their teachers. But Sub-Saharan Africa countries are not provided training to their teachers (Vegas, 2020). Finally, the report suggests that the pandemic will have a very large impact on the education system in the world. Particularly, the education system in low-income countries will be the most negatively affected and less able to provide distance learning and training to teachers (Winthrop, 2020).

# 4. Education System Post-COVID-19

The researchers, curriculum designers, education officers, and educational institutions work together to transform the education system during the closures. Educational institutions should design curriculums, prepare learning strategies and techniques for post-COVID-19, and transform the education system itself. During closures curriculum design, collaborations, skill development, and educational institutions should focus on advancing the education system. After COVID-19, the school’s design strategies and methods to recover lost learning, ensure children return to school when schools reopen, preparing students, parents, and teachers, and to scale distance learning accessibility (Tiruneh, 2020). School teachers in collaboration with education officers need to give awareness for parents and students to make sure that children are safe at home during school closures and trying to learn and read books as much as possible (Crawford et al., 2020).

There is inequality among urban and rural students; students from low-income or high-income and literate or illiterate parents. So that the education system should design and implement some evidence-based actions that aim to facilitate the recovery of the lost portion when schools are reopened. Because of the lack of required support during the school closures, it could take a very long time for children from illiterate and low-income parents to recover their missed portion when they return to school. Some students from low-income parents may decide to work as daily laborers to support their families financially and may never return to school when schools reopen. Parents from rural areas may be unwilling to send their children back to school because they may prefer their children to continue to support them in cattle herding and farming. The schools should trace those students who do not return to school and also even if the countries recover from COVID-19, parents may fear to send their children back to school so that design strategies to encourage parents to send their children back to school (Tiruneh, 2020). The education system needs strategies on how to prepare teachers and students to respond effectively and efficiently during and after COVID-19. Teachers may not teach all the time in a face-to-face classroom; students may not learn in the face-to-face class all the time. When the COVID-19 pandemic is over, the education system needs to prepare everyone to be flexible and adapt quickly to various learning platforms during a time of crisis. The global community may need to support the educational systems in developing countries in their efforts to prepare schools, teachers, students, and parents for the future (Zhu & Liu, 2020).

# 5. Conclusion

The COVID-19 is a pandemic disease caused by a virus that affects the education system of both developing and developed countries. Education is the pillar of every country’s development. In the world, most schools, colleges, and universities are closed to control the spread of the COVID-19. The school closure brings difficulties for students, families, and teachers. So, distance learning is a solution to continue the education system. However, distance learning is challenging in developing countries because many parents have not themselves been to school, lack of ICT infrastructures, computers, radio, and television. The poor and digitally-illiterate families with lower educational levels children with poor learning motivation are more suffering in this situation and this increases inequality. Students in most rural areas may be forced to fully support their families in cattle herding and farming. Also, girl students from low-income families and rural areas can be at a higher risk of sexual abuse, and forced labor, and early marriage. The COVID-19 pandemic has made all the educational schools across the world to adopt teaching and learning online. So, governments should scale network infrastructure and internet connectivity across urban and rural areas. The countries should design a strategy to scale educational technology, establish zero-rating educational resources on the internet, prepare digital teaching and learning resources, utilizing free online learning resources, use mobile learning, use radio and television teaching, and grow-up ICT infrastructures. During closures researchers, curriculum designers, education officers, and educational institutions work together to transform the education system. Schools and universities should design curriculum, prepare learning strategies and techniques for post-COVID-19, and transform the education system itself. After COVID-19, the schools and universities design strategies and methods to recover lost portions, ensure children return to school when schools reopen, and scale online learning infrastructures. Finally, the COVID-19 pandemic has been impacting the face-to-face education system of developing countries. Therefore, developing countries should scale online teaching and learning infrastructures.

# Conflicts of Interest

The authors declare no conflicts of interest regarding the publication of this paper.

# References

Al-Samarrai, S., Gangwar, M., & Gala, P. (2020). The Impactofthe COVID-19 Pandemic on Education Financing. World Bank Other Operational Studies 33739,the World Bank. https://doi.org/10.1596/33739   
Basilaia, G., & Kvavadze, D. (2020). Transition to Online Education in Schools during a SARS-CoV-2 Coronavirus (COVID-19) Pandemic in Georgia. Pedagogical Research, 5, Article No. em0060. https://doi.org/10.29333/pr/7937   
Chick, R. C. (2020). Using Technology to Maintain the Education of Residents during the COVID-19 Pandemic. JournalofSurgicalEducation 77 729-732.   
Crawford, J., Butler-Henderson, K., Rudolph, J. et al. (2020). COVID-19: 20 Countries’ Higher Education Intra-Period Digital Pedagogy Responses. Journal of Applied Teaching and Learning, 3,1-21. https://doi.org/10.37074/jalt.2020.3.1.7   
Di Pietro, G. B., Biagi, F., Dinis Mota Da Costa, P., Karpinski, Z., & Mazza, J. (2020). The Likely Impact of COVID-19 on Education Reflections Based on the Existing Literature and Recent International Datasets. Luxembourg: Publications Office of the European Union.   
Editors (2020). History. A&E Television Networks, LLC. https://www.history.com/topics/middle-ages/pandemics-timeline   
Evans, O. (2020). Socio-Economic Impacts of Novel Coronavirus: The Policy Solutions. BizEcons Quarterly, 7,3-12.   
Haleem, A., Javaid, M., & Vaishya, R. (2020). Effects of COVID-19 Pandemic in Daily Life. CurrentMedicine ResearchandPractice 10 78-79. https://doi.org/10.1016/j.cmrp.2020.03.011   
Healthline Media UK Ltd., B. U. (2020). What to Know about Coronaviruses (K. Center, Editor, & Medicalnewstoday). Medical News Today. https://www.medicalnewstoday.com/articles/256521#mers   
Mustafa, N. (2020). Impact of the 2019-20 Coronavirus Pandemic on Education. International Journal of Health Preferences Research,1-12.   
Ng, Y.-M., & Or, P. L. P. (2020). Coronavirus Disease (COVID-19) Prevention: Virtual Classroom Education for Hand Hygiene. Nurse Education in Practice, 45, Article ID: 102782. https://doi.org/10.1016/j.nepr.2020.102782   
Niranjan, P. S. (2020). Corona Virus Pandemic Impact on Global Education: A Blessing in Disguise. Sustainable Humanosphere, 16, 68-72.   
O’Hagan, C. (2020). Startling Digital Divides in Distance Learning Emerge. UNESCO. https://en.unesco.org/news/startling-digital-divides-distance-learning-emerge   
Osman, M. E. (2020). Global Impact of COVID-19 on Education Systems: The Emergency Remote Teaching at Sultan Qaboos University. Journal of Education for Teaching, 1-10. https://doi.org/10.1080/02607476.2020.1802583   
Owusu-Fordjour, C., Koomson, C. K., & Hanson, D. (2015). The Impact of COVID-19 on Learning: The Perspective of the Ghanaian Student. European Journal of Education Studies, 7, 88-101.   
Pujari, D. R. (2020). Impact of CORONA Virus on Indian Education Systems. UGCCare Journal, 31,1-3.   
Sahu, P. (2020). Closure of Universities Due to Coronavirus Disease 2019 (COVID-19): Impact on Education and Mental Health of Students and Academic Staff. Cureus, 12, e7541. https://doi.org/10.7759/cureus.7541   
Sun, L. T., Tang, Y. M., & Zuo, W. (2020). Coronavirus Pushes Education Online. Nature Materials, 19, 687. https://doi.0rg/10.1038/s41563-020-0678-8   
Thomas, C. J. (2020). Coronavirus and Challenging Times for Education in Developing Countries. Washington DC: The Brookings Institution.   
Tiruneh, D. (2020). COVID-19 School Closures May Further Widen the Inequality Gaps between the Advantaged and the Disadvantaged in Ethiopia. The Education and Development Form. https://www.ukfiet.org/2020/covid-19-school-closures-may-further-widen-the-inequali ty-gaps-between-the-advantaged-and-the-disadvantaged-in-ethiopia/   
TUAC Secretariat Briefing (2020). Impact and Implications of the COVID 19-Crisis on Educational Systems and Households (pp.1-9).The Trade Union Advisory Committee (TUAC) to the OECD.   
Tzifopoulos, M. (2020). In the Shadow of Coronavirus: Distance Education and Digital Literacy Skills in Greece. International Journal of Social Science and Technology, 5, 1-14.   
UNESCO (2020a). Distance Learnin Solutions. UNESCO. https://en.unesco.org/covid19/educationresponse/solutions   
UNESCO (2020b). UNESCO Rallies International Organizations, Civil Society and Private Sector Partners in a Broad Coalition to Ensure #LearningNeverStops.UNESCO. https://en.unesco.org/news/unesco-rallies-international-organizations-civil-society-an d-private-sector-partners-broad   
UNICEF (2020). Key Messages and Actions for COVID-19 Prevention and Control in Schools.   
Varalakshmi, R., & Arunachalam, K. (2020). COVID 2019—Role of Faculty Members to Keep Mental Activeness of Students. AsianJournalofPs chiatr 51 Article ID: 102091. https://doi.org/10.1016/j.ajp.2020.102091   
Vegas, E. (2020). School Closures, Government Responses, and Learning Inequality around the World during COVID-19.Washington DC: The Brookings Institution. https://www.brookings.edu/research/school-closures-government-responses-and-learn ing-inequality-around-the-world-during-covid-19/   
Viner, R. M. et al. (2020). School Closure and Management Practices during Coronavirus Outbreaks Including COVID-19: A Rapid Systematic Review. The Lancet Child & Adolescent Health, 4,397-404. https://doi.0rg/10.1016/S2352-4642(20)30095-X   
Wajdi, M. B. N., Kuswandi, I., Al Faruq, U., Zulhijra, Z., Khairudin , K., & Khoiriyah, K. (2020). Education Policy Overcome Coronavirus, A Study of Indonesians. Journal of Education and Technology, 3, 96-106. https://doi.org/10.29062/edu.v3i2.42   
WHO (2020a). WHO Director-General’s Opening Remarks at the Media Briefing on COVID-19 -11 March 2020. https://www.who.int/dg/speeches/detail/who-director-general-s-opening-remarks-at-t he-media-briefing-on-covid-19---11-march-2020   
WHO (2020b). Archived: WHO Timeline—COVID-19. World Health Organization. https://www.who.int/news-room/detail/27-04-2020-who-timeline---covid-19   
Winthrop, R. (2020). COVID-19 and School Closures: What Can Countries Learn from Past Emergencies?Washington DC: The Brookings Institution.   
Woday, A. et al. (2020). Psychological Impacts of COVID-19 among College Students in Dessie Town,Amhara Region, Ethiopia; Cross-Sectional Study (pp.1-16).Women's Health during the COVID-19 Lockdown.   
Worldometer (2020). Coronavirus. Worldometers.info. https://www.worldometers.info/coronavirus/   
Zhang, X. (2020). Thoughts on Large-Scale Long-Distance Web-Based Teaching in Colleges and Universities Under Novel Coronavirus Pneumonia Epidemic: A Case of Chengdu University. In Proceedings of the 4th International Conference on Culture, Education and Economic Development of Modern Society (ICCESE 2020) (pp. 1222-1225). Amsterdam: Atlantis Press. https://doi.org/10.2991/assehr.k.200316.266   
Zhu, X. D., & Liu, J. (2020). Education in and after Covid-19: Immediate Responses and Long-Term Visions. Postdigital Science and Education, 1-5. https://doi.org/10.1007/s42438-020-00126-3